/******************************************************************************
* (C) Copyright 2007 by Agilent Technologies, All Rights Reserved.
******************************************************************************/

#ifndef PCIEFPGATXMEMORIES_H
#define PCIEFPGATXMEMORIES_H

#include "AgtPCIPort.h"
#include "devpciedefs.h"

const AgtValueT PCIE_MAXIMUM_NUMBER_OF_PROBE_BOARDS_COPY2 = 256; // copy from devpcieintdefs.h

#define TXMEMORIES_BLOCKMEM_LINEWIDTH_DW    ( ( UInt8 )8 )
#define TXMEMORIES_REQBEHMEM_LINEWIDTH_DW   ( ( UInt8 )2 )
#define TXMEMORIES_COMPBEHMEM_LINEWIDTH_DW  ( ( UInt8 )2 )

#define TXMEMORIES_NOFHWCHANNELS  ( ( UInt8 )PCIE_HWCHANNEL_FUNCTION_END )
#define TXMEMORIES_NOFQUEUES      ( ( UInt8 )PCIE_COMPQUEUE_END )

// this is just for performance reasons add adding/removing lines via GUI
// in case there are new properties for the block memory which use DW5/DW6/DW7 please adapt !!
#define TXMEMORIES_BLOCKMEM_LINEWIDTH_ACTUALLY_USED_DW ( ( UInt8 )( TXMEMORIES_BLOCKMEM_LINEWIDTH_DW - 3))

class CAgtPCIEControl;

class CPCIEFpgaTxMemories
{
public:

  // = FOUNDATION

  CPCIEFpgaTxMemories( void );
  ~CPCIEFpgaTxMemories( void );

  // = ACTION
  void setBlockProp( const AgtPortHandleT& portHandle, const EPCIEBlock& prop,
    const EPCIEHwChannelFunction& channel, const UInt32& line, const UInt32& val );
  UInt32 getBlockProp( const AgtPortHandleT& portHandle, const EPCIEBlock& prop,
    const EPCIEHwChannelFunction& channel, const UInt32& line );
  void setBlockLineDefault( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel,
    const UInt32& line );
  UInt32 getBlockLineDW( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel,
    const UInt32& line, const UInt8& dw );
  void setBlockLineDW( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel,
    const UInt32& line, const UInt8& dw, const UInt32& val );

  void setReqBehProp( const AgtPortHandleT& portHandle, const EPCIEReqBeh& prop,
    const EPCIEHwChannelFunction& channel, const UInt32& line, const UInt32& val );
  UInt32 getReqBehProp( const AgtPortHandleT& portHandle, const EPCIEReqBeh& prop,
    const EPCIEHwChannelFunction& channel, const UInt32& line );
  void setReqBehLineDefault( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel,
    const UInt32& line );
  UInt32 getReqBehLineDW( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel,
    const UInt32& line, const UInt8& dw );
  void setReqBehLineDW( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel,
    const UInt32& line, const UInt8& dw, const UInt32& val );

  void setCompBehProp( const AgtPortHandleT& portHandle, const EPCIECompBeh& prop, const EPCIECompQueue& queue,
    const UInt32& line, const UInt32& val );
  UInt32 getCompBehProp( const AgtPortHandleT& portHandle, const EPCIECompBeh& prop, const EPCIECompQueue& queue,
    const UInt32& line );
  void setCompBehLineDefault( const AgtPortHandleT& portHandle, const EPCIECompQueue& queue, const UInt32& line );
  UInt32 getCompBehLineDW( const AgtPortHandleT& portHandle, const EPCIECompQueue& queue, const UInt32& line,
    const UInt8& dw );
  void setCompBehLineDW( const AgtPortHandleT& portHandle, const EPCIECompQueue& queue, const UInt32& line,
    const UInt8& dw, const UInt32& val );

  void update64BitSettings( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel,
    const UInt32& lineNum );
  bool insertBlockLine( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel,
    const UInt32& linePos, const UInt32& validLineCount );
  bool removeBlockLine( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel,
    const UInt32& linePos, const UInt32& validLineCount );
  bool insertReqBehLine( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel,
    const UInt32& linePos, const UInt32& validLineCount );
  bool removeReqBehLine( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel,
    const UInt32& linePos, const UInt32& validLineCount );
  bool insertCompBehLine( const AgtPortHandleT& portHandle, const EPCIECompQueue& queue, const UInt32& linePos,
    const UInt32& validLineCount );
  bool removeCompBehLine( const AgtPortHandleT& portHandle, const EPCIECompQueue& queue, const UInt32& linePos,
    const UInt32& validLineCount );

private:

  bool checkBlockPropValid( const EPCIEBlock& prop );
  bool checkCompBehPropValid( const EPCIECompBeh& prop );

  bool moveBlockLines( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel,
    const UInt32& startLine, UInt32 stopLine, const bool &insert );
  bool moveReqBehLines( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel,
    const UInt32& startLine, UInt32 stopLine, const bool &insert );
  bool moveCompBehLines( const AgtPortHandleT& portHandle, const EPCIECompQueue& queue, const UInt32& startLine,
    UInt32 stopLine, const bool &insert );

  // = FOUNDATION

  // = DATA
  UInt32 mBlockRepeatFirst[PCIE_MAXIMUM_NUMBER_OF_PROBE_BOARDS_COPY2][TXMEMORIES_NOFHWCHANNELS];
  UInt32 mBlockRepeatSecond[PCIE_MAXIMUM_NUMBER_OF_PROBE_BOARDS_COPY2][TXMEMORIES_NOFHWCHANNELS];
  UInt32 mBlockRepeatThird[PCIE_MAXIMUM_NUMBER_OF_PROBE_BOARDS_COPY2][TXMEMORIES_NOFHWCHANNELS];
  UInt32 mBlockRepeatFourth[PCIE_MAXIMUM_NUMBER_OF_PROBE_BOARDS_COPY2][TXMEMORIES_NOFHWCHANNELS];
  UInt32 mBlockRepeatFifth[PCIE_MAXIMUM_NUMBER_OF_PROBE_BOARDS_COPY2][TXMEMORIES_NOFHWCHANNELS];

  UInt32 mReqBehRepeatFirst[PCIE_MAXIMUM_NUMBER_OF_PROBE_BOARDS_COPY2][TXMEMORIES_NOFHWCHANNELS];
  UInt32 mReqBehRepeatSecond[PCIE_MAXIMUM_NUMBER_OF_PROBE_BOARDS_COPY2][TXMEMORIES_NOFHWCHANNELS];
  UInt32 mReqBehRepeatThird[PCIE_MAXIMUM_NUMBER_OF_PROBE_BOARDS_COPY2][TXMEMORIES_NOFHWCHANNELS];
  UInt32 mReqBehRepeatFourth[PCIE_MAXIMUM_NUMBER_OF_PROBE_BOARDS_COPY2][TXMEMORIES_NOFHWCHANNELS];
  UInt32 mReqBehRepeatFifth[PCIE_MAXIMUM_NUMBER_OF_PROBE_BOARDS_COPY2][TXMEMORIES_NOFHWCHANNELS];

  UInt32 mCompBehRepeatFirst[PCIE_MAXIMUM_NUMBER_OF_PROBE_BOARDS_COPY2][TXMEMORIES_NOFQUEUES];
  UInt32 mCompBehRepeatSecond[PCIE_MAXIMUM_NUMBER_OF_PROBE_BOARDS_COPY2][TXMEMORIES_NOFQUEUES];

  CAgtPCIEControl* myController;
};

#endif /* PCIEFPGATXMEMORIES_H */